require( "scripts/style.lua" )

kStartX = 125;
kRow1Y = 135;
kRow2Y = 400;
kHorizontalSpacing = 200;
kVerticalSpacing = 200;
kTextYOffset = 105;
kTextWidth = 150;
kHeaderPaddingX = 10;
kHeaderPaddingY = 4;
kHeaderVerticalSpacing = 40

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/helppage",	
		x=kCenter,
		y=kCenter,

		-- Title at the top
		Text
		{
			font = HelpTableInfoFont,
			name = "help",
			x=0,y=8,w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignTop,
			label = "ui.dialog.help.title"
		};
		
		-- Back button
		Button{
			x = kCenter - 70,
			y = 497,
			--flags = + ,
			font = StandardButtonFont,
			graphics = HelpLeftButtonGraphics,
			name="previous",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu4.lua");
				end
		};
		
		-- "Page X of X" text
		Text
		{			
			x=kCenter,
			y=457,
			w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignCenter,
			font = { standardFont, 20, BlackColor };
			name = "help",
			label = "help_paginate_1",
		};

		-- Next button
		Button{
			x = kCenter + 70,
			y = 497,
			font = StandardButtonFont,
			graphics = HelpRightButtonGraphics,
			name="next",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu2.lua");
				end
		};
			
		-- Close button
		Button{
			--flags = kHAlignCenter+ kVAlignBottom,
			x = kCenter+250,
			y = 501,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="ok",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			label="close",
			type = kPush,
			close=true
		};
		
		-- GOAL HEADER
		Bitmap
		{ 
			image="images/helpscreen/headerbg",	
			x=105,
			y=135-kHeaderVerticalSpacing,
		};
		Text
		{			
			x=105+kHeaderPaddingX,
			y=135-kHeaderVerticalSpacing+kHeaderPaddingY,
			w=kMax ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpHeaderFont;
			name = "help",
			label = "help_header_goal",
		};
		
		-- "Keep the bride and groom...."
		Bitmap
		{ 
			image="images/helpscreen/help_1_image01",	
			x=kStartX + (kHorizontalSpacing*0) - 20,
			y=kRow1Y + kTextYOffset - 65,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) - 20,
			y=kRow1Y,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_goal_text_1",
		};
		
		
		-- "Reach the target number..."
		Bitmap
		{ 
			image="images/helpscreen/help_1_image02",	
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y+45,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_goal_text_2",
		};
		

	        -- "Goal: 2800 and $350 and Level: 1.3"
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1)+25,
			y=kRow1Y + 55,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_goal_text_4",
		};
		
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1)+40,
			y=kRow1Y + 95,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = { nonItalicFont, 17, BlackColor };
			name = "help",
			label = "help_goal_text_5",
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1)+30,
			y=kRow1Y + 121,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_goal_text_6",
		};


		-- "If customers wait too..."
		Bitmap
		{ 
			image="images/helpscreen/help_1_image03",	
			x=kStartX + (kHorizontalSpacing*2),
			y=kRow1Y+60,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*2),
			y=kRow1Y,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_goal_text_3",
		};
		
		
		
		
		-- SEATING HEADER
		Bitmap
		{ 
			image="images/helpscreen/headerbg",	
			x=kStartX - 20,
			y=(kVerticalSpacing*1) + kRow1Y-kHeaderVerticalSpacing + 20,
		};
		Text
		{			
			x=kStartX+kHeaderPaddingX-20,
			y=(kVerticalSpacing*1) + kRow1Y-kHeaderVerticalSpacing+kHeaderPaddingY + 20,
			w=kMax ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpHeaderFont;
			name = "help",
			label = "help_header_seating",
		};
		
		-- "Click and drag each guest...."
		Bitmap
		{ 
			image="images/helpscreen/help_1_image04",	
			x=kStartX + (kHorizontalSpacing*0) + 240,
			y=(kVerticalSpacing*1) + kRow1Y,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0)-20,
			y=(kVerticalSpacing*1) + kRow1Y + kTextYOffset - 80,
			w=200 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_seating_text_1",
		};
		
		-- "Seat guests according to..."
		--[[Bitmap
		{ 
			image="images/helpscreen/help_1_image02",	
			x=kStartX + (kHorizontalSpacing*1),
			y=(kVerticalSpacing*1) + kRow1Y,
		};]]--
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) - 20,
			y=(kVerticalSpacing*1) + kRow1Y + kTextYOffset - 40,
			w=200 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_seating_text_2",
		};
		
	}
}



